////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/OrchestrationException.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * <p>The {@link PasswordException} exception is raised when a user-input password error arises.</p>
 */
@interface PasswordException : OrchestrationException

/** Error code attached to the exception  (see OrchestrationErrorCodes.h)*/
@property (nonatomic, readonly) int errorCode;

/**
 * Constructor
 * @param message message describing the exception
 * @param errorCode error code (see OrchestrationErrorCodes.h)
 */
- (id)initWithMessage:(NSString *)message errorCode:(int)errorCode;

@end

NS_ASSUME_NONNULL_END
